#include "consoleutil.h"
#include "rect.h"
#include <stdio.h>

void Rect::print()
{
	printf("[(%f, %f), (%f, %f)]", min.x, min.y, max.x, max.y);
}

void Rect::draw(char letter)
{
	Vector2 i;
	for(i.y = (float)((int)min.y); i.y < max.y; ++i.y)
	{
		for(i.x = (float)((int)min.x); i.x < max.x; ++i.x)
		{
			// only print in a standard console window
			if(i.isWithin(0, 0, 80, 24))
			{
				moveCursor((int)i.x, (int)i.y);
				putchar(letter);
			}
		}
	}
}

void Rect::translate(Vector2 delta)
{
	min += delta;
	max += delta;
}

float Rect::getArea()
{
	return getWidth() * getHeight();
}

/** @param v if the argument is out of the Rect, the Rect will extend */
void Rect::add(Vector2 v)
{
	if(v.x < min.x) { min.x = v.x; }
	if(v.y < min.y) { min.y = v.y; }
	if(v.x > max.x) { max.x = v.x; }
	if(v.y > max.y) { max.y = v.y; }
}
